/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230516
* Description : 演示进入PWOFF低功耗模式，并通过产生IO中断（PBIF）进行唤醒的功能。
*               进入PWOFF模式之前，IO口PB2进行100次翻转，进入PWOFF模式睡眠后，IO口PB2停止翻转；
*				通过给PB0输入变化的高低电平，会在电平变化时产生PBIF中断进而唤醒PWOFF低功耗模式，唤醒后IO口PB2会再次进行翻转。
********************************************************************************/
#include "AD18F08.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF        :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL_LOW		    :  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _MTPDIS_OFF       ： SWD模式下读FLASH和EEPROM控位
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L      & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L      & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                     );

#define SLEEP_PWIDLE() 		SMCR = 0X01; SLEEP();NOP();NOP()
#define SLEEP_PWSAVE() 		SMCR = 0X03; SLEEP();NOP();NOP()
#define SLEEP_DEEPPWSAVE()  SMCR = 0X05; SLEEP();NOP();NOP()
#define SLEEP_PWOFF() 		SMCR = 0X07; SLEEP();NOP();NOP()

void main(void)
{
	unsigned char i;
    volatile unsigned char tmp=0;

    CLKCFG1=0X00;  	//关闭时钟

	PAOD = 0X00;
	PBOD = 0X00;	//关闭开漏

	PAPU = 0XFF;
	PBPU = 0XFE;	//PB0打开上拉

	PAPD = 0XFF;
	PBPD = 0XFF;	//关闭下拉

	TRISA=0X00;
	TRISB=0X01;	 	//PB0设为输入模式 PB2设为输出模式

	PORTA=0X00;
	PORTB=0X00;		//IO初始化为低电平

    PBINTMASK=0X01; //使能PB0端口电平变化中断

    IPEN=1;//允许高低优先级中断
	GIEH=1;//使能高优先级中断
	PEIE=1;//使能低优先级中断
    PBIP=1;//PB设为高优先级中断
    PBIF=0;
    PBIE=1;

	while(1)
	{
		for(i=0;i<100;i++)
		{
			PB2=~PB2;
			__delay_us(5000);
		}
		PB2=0;
        tmp=PINB;          	//锁存IO状态

		//SLEEP_PWIDLE();
		//SLEEP_PWSAVE();
		//SLEEP_DEEPPWSAVE();
		SLEEP_PWOFF();	//进入pwoff低功耗模式
	}
}


//中断服务函数
void __interrupt(high_priority) ISR_h(void)
{
	unsigned char tmp_int;
    tmp_int = PIR2;
	if(((tmp_int&0X40==0X40))&((tmp_int&0X40==0X40)))
	{
		PBIF=0;
	}
	if(((tmp_int&0X20==0X20))&((tmp_int&0X20==0X20)))
	{
		PAIF=0;
	}
}
//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}

